﻿/// <reference name="MicrosoftAjax.js"/>


Type.registerNamespace("TextBoxInfoControl");

TextBoxInfoControl.TextBoxInfo = function(element) {
    TextBoxInfoControl.TextBoxInfo.initializeBase(this, [element]);
    this._textBoxElement;
    this._imageElement;
    this._informationText;
}

TextBoxInfoControl.TextBoxInfo.prototype = {
    initialize: function() {
        TextBoxInfoControl.TextBoxInfo.callBaseMethod(this, 'initialize');
        $addHandlers(this._imageElement,{"click":this._imageElementClickHandler},this);
    },
    get_informationText: function(){
        return this._informationText;
    },
    set_informationText: function(value){
        this._informationText = value;
    },
    get_textBoxElement: function(){
        return this._textBoxElement;
    },
    set_textBoxElement: function(value){
        this._textBoxElement = value;
    },
    get_imageElement: function(){
        return this._imageElement;
    },
    set_imageElement: function(value){
        this._imageElement = value;
    },
    _imageElementClickHandler: function(e){
        alert(this._informationText);
    },
    get_text: function(){
        if(this._textBoxElement === "undefined")
            return "";
        else
            return this._textBoxElement;
    },
    set_text: function(value){
        if(this._textBoxElement !== "undefined")
            this._textBoxElement = value;
    },
    dispose: function() {        
    
        // tutaj należy dodać niestandardowy kod zwalniający
        TextBoxInfoControl.TextBoxInfo.callBaseMethod(this, 'dispose');
    }
}
TextBoxInfoControl.TextBoxInfo.registerClass('TextBoxInfoControl.TextBoxInfo', Sys.UI.Control);

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();